#!/usr/bin/env python
"""
Zapalanie diod LED w dyskotekowej sekwencji za pomocą karty PiFace
"""
import time                     # Na potrzeby dodawania opóźnień
import piface.pfio as pfio      # Biblioteka piface
import os, pygame, sys

pfio.init()                     # Inicjowanie obiektu pfio
pygame.init()                   # Inicjowanie interfejsu graficznego
os.environ['SDL_VIDEO_WINDOW_POS'] = 'center'
pygame.display.set_caption("Kontroler diod LED")
screen = pygame.display.set_mode([788,250],0,32)
background = pygame.Surface((788,250))

# Definiowanie kolorów interfejsu użytkownika
cBackground =(255,255,255)
cLEDon = (255,0,0)
cLEDoff = (128,128,128)
cOutline = (255,128,0)
cText = (0,0,0)
cTextBack = (220,220,220)
cStepBlock = (0,255,255)

background.fill(cBackground) # Określanie koloru tła
font = pygame.font.Font(None, 28)
seq = [ 1 << (temp & 0x7) for temp in range (0,32)] # Początkowa sekwencja
timeInc = 0.3
stepInt = True # Pobieranie sygnałów o kroku z Raspberry Pi
step = 0 # Początkowy punkt sekwencji
nextTime = time.time()
lastSwitch = 0

def main():
        setupScreen()
        while True :
            checkForEvent()
            checkStep()
            
def checkStep() :
        global step, nextTime, lastSwitch
        if stepInt : # Jeśli polecenie przejścia do następnego kroku pochodzi z wewnętrznego zegara
            if time.time() > nextTime : # należy zrobić następny krok
                   updateSeq(step)
                   step += 1
                   if step >31 :
                           step = 0
                   nextTime = time.time() + timeInc
        else: # W przeciwnym razie należy sprawdzić stan odpowiedniego przełącznika
                   switchState = pfio.read_input() & 1
                   if switchState != lastSwitch and lastSwitch == 0:
                           updateSeq(step)
                           step += 1
                           if step >31 :
                                   step = 0
                   lastSwitch = switchState                 

def updateSeq(n) :
        pygame.draw.rect(screen,cBackground, (10, 202,768 ,10), 0) # Zerowanie linii
        pygame.draw.rect(screen,cStepBlock, (14 + n * 24, 202,10 ,10), 0) # Rysowanie nowego kroku
        pygame.display.update()
        pfio.write_output(seq[n])
        
def setupScreen() : # Inicjowanie ekranu
        screen.blit(background,[0,0]) # set Ustawianie koloru tła
        drawControl(10,58,"Zeruj")
        drawControl(86,82,u"Odwróć")
        drawControl(188,88,"Szybciej")
        drawControl(295,74,"Wolniej")
        drawControl(390,152,"Automatycznie")


        for x in range(0,32) :
             drawCol(x,seq[x])
        pygame.display.update()

def drawControl(xPos,xLen,name) :
        pygame.draw.rect(screen,cTextBack, (xPos, 216, xLen,32), 0)
        pygame.draw.rect(screen,cOutline, (xPos, 216, xLen,32), 2)
        text = font.render(name, True, cText, cTextBack )
        textRect = text.get_rect()
        textRect.topleft = xPos+4, 220
        screen.blit(text, textRect)

def drawCol(x,value):
        boxNum = 0
        x = 10 + x*24
        y = 10
        for bit in range(0,8):
                # Najpierw rysowane jest pole; kolor wypełnienia zależy od sekwencji bitów
                if ((value >> boxNum) & 1) != 1 :
                        pygame.draw.rect(screen,cLEDoff, (x, y + 24*boxNum, 20,20), 0)
                else :
                        pygame.draw.rect(screen,cLEDon, (x, y + 24*boxNum, 20,20), 0)
                # Rysowanie obramowania pola
                pygame.draw.rect(screen,cOutline,(x, y + 24*boxNum, 20,20), 2)
                boxNum +=1
                
def mouseGet() : # Sprawdzanie, gdzie kliknął użytkownik, i wykonywanie odpowiednich operacji
        global timeInc, stepInt
        x,y = pygame.mouse.get_pos()
        if y in range(10, 202) and x in range(10, 778 ) :
                bit = (y -10) / 24
                byte = (x- 10) / 24
                seq[byte] ^= 1 << bit
                drawCol(byte,seq[byte])
                pygame.display.update()
        elif y in range(216,248) :
                if x in range(10,58) : # Kontrolka zerowania
                              for a in range(0,32):
                                      seq[a] = 0
                                      drawCol(a,seq[a])
                              pygame.display.update()        
                if x in range(86,168) : # Kontrolka odwracania ustawień
                              for a in range(0,32):
                                      seq[a] ^= 0xff
                                      drawCol(a,seq[a])
                              pygame.display.update()
                if x in range(188,276) : # Kontrolka przyspieszania
                              timeInc -= 0.05
                              if timeInc <= 0 :
                                      timeInc = 0.05
                if x in range(295,369) : # Kontrolka spowalniania
                              timeInc += 0.05
                if x in range(390,542) : # Kontrolka do określania źródła sygnałów zmiany kroku
                              stepInt = not stepInt
                              if stepInt :
                                   drawControl(390,152,"Automatycznie")
                              else:
                                   drawControl(390,152,"Zewnętrznie")
                              pygame.display.update()                                   
        else:
                #print "Kursor myszy ",x,y 
                
def terminate(): # Zamykanie programu
    print ("Trwa zamykanie programu - proszę czekać")
    pfio.deinit()                               # Zamykanie obiektu pfio
    pygame.quit()
    sys.exit()
    
def checkForEvent(): # Sprawdzanie, czy należy zamknąć program lub czy użytkownik kliknął myszą
    #print "Sprawdzanie, czy należy zamknąć program"
    event = pygame.event.poll()
    if event.type == pygame.QUIT :
           terminate()
    elif event.type == pygame.MOUSEBUTTONDOWN :
            mouseGet()
    elif event.type == pygame.KEYDOWN and event.key == pygame.K_ESCAPE :
            terminate()
            
if __name__ == '__main__':
    main()   
